/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.jts.mgeom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Envelope;
import java.io.Serializable;
import org.hibernate.spatial.jts.mgeom.MCoordinate;

public class MCoordinateSequence
implements CoordinateSequence,
Serializable {
    private static final long serialVersionUID = 1L;
    private MCoordinate[] coordinates;

    public static MCoordinate[] copy(Coordinate[] coordinates) {
        MCoordinate[] copy = new MCoordinate[coordinates.length];
        for (int i = 0; i < coordinates.length; ++i) {
            copy[i] = new MCoordinate(coordinates[i]);
        }
        return copy;
    }

    public static MCoordinate[] copy(CoordinateSequence coordSeq) {
        MCoordinate[] copy = new MCoordinate[coordSeq.size()];
        for (int i = 0; i < coordSeq.size(); ++i) {
            copy[i] = new MCoordinate(coordSeq.getCoordinate(i));
        }
        return copy;
    }

    public MCoordinateSequence(MCoordinate[] coordinates) {
        this.coordinates = coordinates;
    }

    public MCoordinateSequence(Coordinate[] copyCoords) {
        this.coordinates = MCoordinateSequence.copy(copyCoords);
    }

    public MCoordinateSequence(CoordinateSequence coordSeq) {
        this.coordinates = MCoordinateSequence.copy(coordSeq);
    }

    public MCoordinateSequence(int size) {
        this.coordinates = new MCoordinate[size];
        for (int i = 0; i < size; ++i) {
            this.coordinates[i] = new MCoordinate();
        }
    }

    public int getDimension() {
        return 4;
    }

    public Coordinate getCoordinate(int i) {
        return this.coordinates[i];
    }

    public Coordinate getCoordinateCopy(int index) {
        return new Coordinate((Coordinate)this.coordinates[index]);
    }

    public void getCoordinate(int index, Coordinate coord) {
        coord.x = this.coordinates[index].x;
        coord.y = this.coordinates[index].y;
    }

    public double getX(int index) {
        return this.coordinates[index].x;
    }

    public double getY(int index) {
        return this.coordinates[index].y;
    }

    public double getM(int index) {
        return this.coordinates[index].m;
    }

    public double getOrdinate(int index, int ordinateIndex) {
        switch (ordinateIndex) {
            case 0: {
                return this.coordinates[index].x;
            }
            case 1: {
                return this.coordinates[index].y;
            }
            case 2: {
                return this.coordinates[index].z;
            }
            case 3: {
                return this.coordinates[index].m;
            }
        }
        return Double.NaN;
    }

    public void setOrdinate(int index, int ordinateIndex, double value) {
        switch (ordinateIndex) {
            case 0: {
                this.coordinates[index].x = value;
                break;
            }
            case 1: {
                this.coordinates[index].y = value;
                break;
            }
            case 2: {
                this.coordinates[index].z = value;
                break;
            }
            case 3: {
                this.coordinates[index].m = value;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid ordinateIndex");
            }
        }
    }

    public Object clone() {
        MCoordinate[] cloneCoordinates = new MCoordinate[this.size()];
        for (int i = 0; i < this.coordinates.length; ++i) {
            cloneCoordinates[i] = (MCoordinate)((Object)this.coordinates[i].clone());
        }
        return new MCoordinateSequence(cloneCoordinates);
    }

    public int size() {
        return this.coordinates.length;
    }

    public Coordinate[] toCoordinateArray() {
        return this.coordinates;
    }

    public Envelope expandEnvelope(Envelope env) {
        for (int i = 0; i < this.coordinates.length; ++i) {
            env.expandToInclude((Coordinate)this.coordinates[i]);
        }
        return env;
    }

    public String toString() {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("MCoordinateSequence [");
        for (int i = 0; i < this.coordinates.length; ++i) {
            if (i > 0) {
                strBuf.append(", ");
            }
            strBuf.append((Object)this.coordinates[i]);
        }
        strBuf.append("]");
        return strBuf.toString();
    }
}

