/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.jts.mgeom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.Point;
import java.util.ArrayList;
import org.hibernate.spatial.jts.mgeom.MCoordinate;
import org.hibernate.spatial.jts.mgeom.MGeometry;
import org.hibernate.spatial.jts.mgeom.MGeometryException;
import org.hibernate.spatial.jts.mgeom.MLineString;

public class MultiMLineString
extends MultiLineString
implements MGeometry {
    private static final long serialVersionUID = 1L;
    private final double mGap;
    private boolean monotone = false;
    private boolean strictMonotone = false;

    public MultiMLineString(MLineString[] MlineStrings, double mGap, GeometryFactory factory) {
        super((LineString[])MlineStrings, factory);
        this.mGap = mGap;
        this.determineMonotone();
    }

    private void determineMonotone() {
        MLineString ml;
        int i;
        this.monotone = true;
        this.strictMonotone = true;
        if (this.isEmpty()) {
            return;
        }
        int mdir = 0;
        for (i = 0; i < this.geometries.length; ++i) {
            ml = (MLineString)this.geometries[0];
            if (ml.isEmpty()) continue;
            mdir = ml.getMeasureDirection();
            break;
        }
        for (i = 0; i < this.geometries.length; ++i) {
            ml = (MLineString)this.geometries[i];
            if (ml.isEmpty()) continue;
            if (!ml.isMonotone(false) || ml.getMeasureDirection() != mdir && ml.getMeasureDirection() != 0) {
                this.monotone = false;
                break;
            }
            if (!ml.isMonotone(true) || ml.getMeasureDirection() != mdir) {
                this.strictMonotone = false;
                break;
            }
            if (i <= 0) continue;
            MLineString mlp = (MLineString)this.geometries[i - 1];
            if (mdir == 1) {
                if (mlp.getMaxM() > ml.getMinM()) {
                    this.monotone = false;
                    continue;
                }
                if (!(mlp.getMaxM() >= ml.getMinM())) continue;
                this.strictMonotone = false;
                continue;
            }
            if (mlp.getMinM() < ml.getMaxM()) {
                this.monotone = false;
                continue;
            }
            if (!(mlp.getMinM() <= ml.getMaxM())) continue;
            this.strictMonotone = false;
        }
        if (!this.monotone) {
            this.strictMonotone = false;
        }
    }

    protected void geometryChangedAction() {
        this.determineMonotone();
    }

    public String getGeometryType() {
        return "MultiMLineString";
    }

    public double getMGap() {
        return this.mGap;
    }

    @Override
    public double getMatCoordinate(Coordinate co, double tolerance) throws MGeometryException {
        if (!this.isMonotone(false)) {
            throw new MGeometryException(1);
        }
        double mval = Double.NaN;
        double dist = Double.POSITIVE_INFINITY;
        Point p = this.getFactory().createPoint(co);
        for (int i = 0; i < this.getNumGeometries(); ++i) {
            double d;
            MCoordinate mc;
            MLineString ml = (MLineString)this.getGeometryN(i);
            if (ml.distance((Geometry)p) > tolerance || (mc = ml.getClosestPoint(co, tolerance)) == null || !((d = mc.distance(co)) <= tolerance) || !(d < dist)) continue;
            dist = d;
            mval = mc.m;
        }
        return mval;
    }

    public Object clone() {
        MultiLineString ml = (MultiLineString)super.clone();
        return ml;
    }

    @Override
    public void measureOnLength(boolean keepBeginMeasure) {
        double startM = 0.0;
        for (int i = 0; i < this.getNumGeometries(); ++i) {
            MLineString ml = (MLineString)this.getGeometryN(i);
            if (i == 0) {
                ml.measureOnLength(keepBeginMeasure);
            } else {
                ml.measureOnLength(false);
            }
            if (startM != 0.0) {
                ml.shiftMeasure(startM);
            }
            startM += ml.getLength() + this.mGap;
        }
        this.geometryChanged();
    }

    @Override
    public Coordinate getCoordinateAtM(double m) throws MGeometryException {
        if (!this.isMonotone(false)) {
            throw new MGeometryException(1);
        }
        Coordinate c = null;
        for (int i = 0; i < this.getNumGeometries(); ++i) {
            MGeometry mg = (MGeometry)this.getGeometryN(i);
            c = mg.getCoordinateAtM(m);
            if (c == null) continue;
            return c;
        }
        return null;
    }

    @Override
    public CoordinateSequence[] getCoordinatesBetween(double begin, double end) throws MGeometryException {
        if (!this.isMonotone(false)) {
            throw new MGeometryException(1, "Operation requires geometry with monotonic measures");
        }
        if (this.isEmpty()) {
            return null;
        }
        ArrayList<CoordinateSequence> ar = new ArrayList<CoordinateSequence>();
        for (int i = 0; i < this.getNumGeometries(); ++i) {
            MLineString ml = (MLineString)this.getGeometryN(i);
            for (CoordinateSequence cs : ml.getCoordinatesBetween(begin, end)) {
                if (cs.size() <= 0) continue;
                ar.add(cs);
            }
        }
        return ar.toArray(new CoordinateSequence[ar.size()]);
    }

    @Override
    public double getMinM() {
        double minM = Double.POSITIVE_INFINITY;
        for (int i = 0; i < this.getNumGeometries(); ++i) {
            MLineString ml = (MLineString)this.getGeometryN(i);
            double d = ml.getMinM();
            if (!(d < minM)) continue;
            minM = d;
        }
        return minM;
    }

    @Override
    public double getMaxM() {
        double maxM = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.getNumGeometries(); ++i) {
            MLineString ml = (MLineString)this.getGeometryN(i);
            double d = ml.getMaxM();
            if (!(d > maxM)) continue;
            maxM = d;
        }
        return maxM;
    }

    @Override
    public boolean isMonotone(boolean strictMonotone) {
        return strictMonotone ? this.strictMonotone : this.monotone;
    }

    @Override
    public Geometry asGeometry() {
        return this;
    }
}

