/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.smoothline;

import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.vectorediting.lib.prov.smoothline.ControlCurve;

public class Bezier
extends ControlCurve {
    public Bezier(Line line) {
        super(line);
    }

    static float b(int i, float t) {
        switch (i) {
            case 0: {
                return (1.0f - t) * (1.0f - t) * (1.0f - t);
            }
            case 1: {
                return 3.0f * t * (1.0f - t) * (1.0f - t);
            }
            case 2: {
                return 3.0f * t * t * (1.0f - t);
            }
            case 3: {
                return t * t * t;
            }
        }
        return 0.0f;
    }

    Point p(int i, float t, int subtype) throws CreateGeometryException {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        float px = 0.0f;
        float py = 0.0f;
        for (int j = 0; j <= 3; ++j) {
            px = (float)((double)px + (double)Bezier.b(j, t) * this.m_X[i + j]);
            py = (float)((double)py + (double)Bezier.b(j, t) * this.m_Y[i + j]);
        }
        return geomManager.createPoint((double)Math.round(px), (double)Math.round(py), subtype);
    }

    @Override
    public Line getSmoothedLine(int iSteps, int subtype) throws CreateGeometryException {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        Line line = geomManager.createLine(subtype);
        Point q = this.p(0, 0.0f, subtype);
        line.addVertex(q);
        for (int i = 0; i < this.m_X.length - 3; i += 3) {
            for (int j = 1; j <= iSteps; ++j) {
                q = this.p(i, (float)j / (float)iSteps, subtype);
                line.addVertex(q);
            }
        }
        return line;
    }
}

