/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.smoothline;

import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.vectorediting.lib.prov.smoothline.ControlCurve;
import org.gvsig.vectorediting.lib.prov.smoothline.Cubic;

public class NatCubic
extends ControlCurve {
    public NatCubic(Line line) {
        super(line);
    }

    Cubic[] calcNaturalCubic(int n, double[] x) {
        int i;
        double[] gamma = new double[n + 1];
        double[] delta = new double[n + 1];
        double[] D = new double[n + 1];
        gamma[0] = 0.5;
        for (i = 1; i < n; ++i) {
            gamma[i] = 1.0 / (4.0 - gamma[i - 1]);
        }
        gamma[n] = 1.0 / (2.0 - gamma[n - 1]);
        delta[0] = 3.0 * (x[1] - x[0]) * gamma[0];
        for (i = 1; i < n; ++i) {
            delta[i] = (3.0 * (x[i + 1] - x[i - 1]) - delta[i - 1]) * gamma[i];
        }
        delta[n] = (3.0 * (x[n] - x[n - 1]) - delta[n - 1]) * gamma[n];
        D[n] = delta[n];
        for (i = n - 1; i >= 0; --i) {
            D[i] = delta[i] - gamma[i] * D[i + 1];
        }
        Cubic[] C = new Cubic[n];
        for (i = 0; i < n; ++i) {
            C[i] = new Cubic(x[i], D[i], 3.0 * (x[i + 1] - x[i]) - 2.0 * D[i] - D[i + 1], 2.0 * (x[i] - x[i + 1]) + D[i] + D[i + 1]);
        }
        return C;
    }

    @Override
    public Line getSmoothedLine(int iSteps, int subtype) throws CreateGeometryException {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        if (this.m_X.length >= 2) {
            Cubic[] X = this.calcNaturalCubic(this.m_X.length - 1, this.m_X);
            Cubic[] Y = this.calcNaturalCubic(this.m_Y.length - 1, this.m_Y);
            Line smoothedLine = geomManager.createLine(subtype);
            smoothedLine.addVertex((double)((int)Math.round(X[0].eval(0.0))), (double)((int)Math.round(Y[0].eval(0.0))));
            for (int i = 0; i < X.length; ++i) {
                for (int j = 1; j <= iSteps; ++j) {
                    float u = (float)j / (float)iSteps;
                    smoothedLine.addVertex(X[i].eval(u), Y[i].eval(u));
                }
            }
            return smoothedLine;
        }
        return this.line;
    }
}

