/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.spi;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.aggregate.MultiPrimitive;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.service.spi.AbstractProvider;
import org.gvsig.tools.service.spi.ProviderServices;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.vectorediting.lib.api.EditingServiceParameter;
import org.gvsig.vectorediting.lib.api.exceptions.InvalidEntryException;
import org.gvsig.vectorediting.lib.api.exceptions.StartServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.StopServiceException;
import org.gvsig.vectorediting.lib.spi.EditingProvider;
import org.gvsig.vectorediting.lib.spi.EditingProviderServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEditingProvider
extends AbstractProvider
implements EditingProvider,
Geometry.TYPES,
Geometry.SUBTYPES {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractEditingProvider.class);
    private boolean showPreviewSymbol = true;

    public AbstractEditingProvider(ProviderServices providerServices) {
        super(providerServices);
    }

    @Override
    public boolean isEnabled(EditingServiceParameter parameter) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public abstract void setValue(EditingServiceParameter var1, Object var2) throws InvalidEntryException;

    @Override
    public void activate() {
    }

    @Override
    public Object getValue(EditingServiceParameter parameter) {
        LOGGER.warn("'" + this.getClass().getName() + "' dooes not implement the method 'getValue'.");
        return null;
    }

    @Override
    public Object getValue(EditingServiceParameter parameter, EditingServiceParameter.TYPE type) {
        return this.getValue(parameter);
    }

    protected EditingProviderServices getProviderServices() {
        return (EditingProviderServices)super.getProviderServices();
    }

    @Override
    public void setDefaultFeatureValues(EditableFeature feature) {
        this.getProviderServices().setDefaultFeatureValues(feature);
    }

    @Override
    public EditableFeature getDefaultFeatureValues() {
        return this.getProviderServices().getDefaultFeatureValues();
    }

    public ISymbol getPreviewSymbol() {
        if (!this.showPreviewSymbol) {
            return null;
        }
        return this.getProviderServices().getPreviewSymbol();
    }

    public ISymbol getPreviewSymbol(Feature feature) {
        if (!this.showPreviewSymbol) {
            return null;
        }
        return this.getProviderServices().getPreviewSymbol(feature);
    }

    @Override
    public void setShowPreviewSymbol(boolean showPreviewSymbol) {
        this.showPreviewSymbol = showPreviewSymbol;
    }

    @Override
    public boolean isShowPreviewSymbol() {
        return this.showPreviewSymbol;
    }

    @Override
    public void restart() throws StartServiceException, InvalidEntryException, StopServiceException {
        this.stop();
        this.start();
    }

    @Override
    public void initDefaultValues() {
        List parameters = this.getParameters();
        for (EditingServiceParameter parameter : parameters) {
            if (!parameter.isOptional() || this.getValue(parameter) != null) continue;
            try {
                this.setValue(parameter, parameter.getDefaultValue());
            }
            catch (InvalidEntryException ex) {
                LOGGER.debug("Can't init default value of " + parameter.getName(), (Throwable)ex);
            }
        }
    }

    public List<Feature> getSelectedFeaturesCopy(FeatureSelection selection) {
        SimpleTaskStatus status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus("Loading selection");
        try {
            status.add();
            status.setAutoremove(true);
            status.setRangeOfValues(0L, (long)selection.size());
            ArrayList<Feature> features = new ArrayList<Feature>();
            DisposableIterator it = selection.fastIterator();
            while (it.hasNext()) {
                if (status.isCancellationRequested()) {
                    status.cancel();
                    return features;
                }
                Feature feature = (Feature)it.next();
                if (feature.getDefaultGeometry() == null) continue;
                features.add(feature.getCopy());
                status.incrementCurrentValue();
            }
            status.terminate();
            return features;
        }
        catch (DataException ex) {
            status.abort();
            throw new RuntimeException("Can't calculate selected features", ex);
        }
    }

    @Override
    public boolean mustRestartAtFinish() {
        return true;
    }

    protected Geometry makeMultiPrimitiveIsNeeded(FeatureStore featureStore, Primitive primitive) throws DataException, CreateGeometryException {
        EditingProviderServices editingProviderServices;
        GeometryType storeGeomType;
        GeometryManager geometryManager;
        if (primitive != null && (geometryManager = GeometryLocator.getGeometryManager()).canAggregate((storeGeomType = (editingProviderServices = this.getProviderServices()).getGeomType(featureStore)).getType(), primitive.getGeometryType().getType())) {
            MultiPrimitive aggregate = (MultiPrimitive)geometryManager.create(storeGeomType.getType(), storeGeomType.getSubType());
            aggregate.addPrimitive(primitive);
            return aggregate;
        }
        return primitive;
    }
}

