/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.spi;

import java.awt.Image;
import java.util.List;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.vectorediting.lib.api.EditingLocator;
import org.gvsig.vectorediting.lib.api.EditingManager;
import org.gvsig.vectorediting.lib.api.EditingService;
import org.gvsig.vectorediting.lib.api.EditingServiceInfo;
import org.gvsig.vectorediting.lib.api.EditingServiceParameter;
import org.gvsig.vectorediting.lib.api.exceptions.ServiceInformationException;

public class DefaultEditingServiceinfo
implements EditingServiceInfo {
    private final String name;
    private final String description;
    private final boolean createsNewGeometries;
    private final Image mouseCursor;
    private List<EditingServiceParameter> parameters;
    private final int[] supportedPrimitiveGeometryType;

    public DefaultEditingServiceinfo(String name, String description, boolean createsNewGeometries, Image mouseCursor, int[] supportedPrimitiveGeometryType) {
        this.name = name;
        this.description = description;
        this.createsNewGeometries = createsNewGeometries;
        this.mouseCursor = mouseCursor;
        this.supportedPrimitiveGeometryType = supportedPrimitiveGeometryType;
    }

    public boolean createsNewGeometries() {
        return this.createsNewGeometries;
    }

    public String getDescription() {
        return this.description;
    }

    public Image getMouseIcon() {
        return this.mouseCursor;
    }

    public String getName() {
        return this.name;
    }

    public List<EditingServiceParameter> getParameters() {
        return this.parameters;
    }

    public int[] getSupportedPrimitiveGeometryTypes() {
        return this.supportedPrimitiveGeometryType;
    }

    public EditingServiceParameter getParameterInfo(String parameterName) {
        if (this.parameters == null) {
            EditingManager manager = EditingLocator.getManager();
            EditingService editingService = manager.getEditingService(this.name, null, null, null);
            this.parameters = editingService.getParameters();
        }
        for (EditingServiceParameter editingServiceParameter : this.parameters) {
            if (!editingServiceParameter.getName().equalsIgnoreCase(parameterName)) continue;
            return editingServiceParameter;
        }
        return null;
    }

    public boolean isCompatibleWith(GeometryType geoType) throws ServiceInformationException {
        int[] supportedTypes = this.getSupportedPrimitiveGeometryTypes();
        for (int i = 0; i < supportedTypes.length; ++i) {
            GeometryType supportedGeomType;
            try {
                supportedGeomType = GeometryLocator.getGeometryManager().getGeometryType(supportedTypes[i], geoType.getSubType());
            }
            catch (Exception e) {
                throw new ServiceInformationException("Can't get geometry type with type " + supportedTypes[i] + " and subtype " + geoType.getSubType(), (Throwable)e);
            }
            if (!supportedGeomType.isTypeOf(geoType)) continue;
            return true;
        }
        return false;
    }
}

