/*
*   Class   PrintToScreen
*
*   USAGE:  Methods for writing one and two dimensional arrays to the sceen
*
*   WRITTEN BY: Dr Michael Thomas Flanagan
*
*   DATE:    13  April 2008  (Most methods taken from existing classes to make a separate print to screen class)
*   AMENDED:
*
*   DOCUMENTATION:
*   See Michael Thomas Flanagan's Java library on-line web pages:
*   http://www.ee.ucl.ac.uk/~mflanaga/java/PrintToScreen.html
*   http://www.ee.ucl.ac.uk/~mflanaga/java/
*
*   Copyright (c) 2008
*
*   PERMISSION TO COPY:
*   Permission to use, copy and modify this software and its documentation for
*   NON-COMMERCIAL purposes is granted, without fee, provided that an acknowledgement
*   to the author, Michael Thomas Flanagan at www.ee.ucl.ac.uk/~mflanaga, appears in all copies.
*
*   Dr Michael Thomas Flanagan makes no representations about the suitability
*   or fitness of the software for any or for a particular purpose.
*   Michael Thomas Flanagan shall not be liable for any damages suffered
*   as a result of using, modifying or distributing this software or its derivatives.
*
***************************************************************************************/

package flanagan.io;

import java.math.*;

import flanagan.complex.Complex;
import flanagan.circuits.Phasor;

public class PrintToScreen{

        // 1D ARRAYS

        // print an array of doubles to screen
        // No line returns except at the end
        public static void print(double[] aa){
            for(int i=0; i<aa.length; i++){
                System.out.print(aa[i]+"   ");
            }
            System.out.println();
        }

        // print an array of doubles to screen
        // with line returns
        public static void println(double[] aa){
            for(int i=0; i<aa.length; i++){
                System.out.println(aa[i]+"   ");
            }
        }

        // print an array of floats to screen
        // No line returns except at the end
        public static void print(float[] aa){
            for(int i=0; i<aa.length; i++){
                System.out.print(aa[i]+"   ");
            }
            System.out.println();
        }

        // print an array of floats to screen
        // with line returns
        public static void println(float[] aa){
            for(int i=0; i<aa.length; i++){
                System.out.println(aa[i]+"   ");
            }
        }

        // print an array of ints to screen
        // No line returns except at the end
        public static void print(int[] aa){
            for(int i=0; i<aa.length; i++){
                System.out.print(aa[i]+"   ");
            }
            System.out.println();
        }

        // print an array of ints to screen
        // with line returns
        public static void println(int[] aa){
            for(int i=0; i<aa.length; i++){
                System.out.println(aa[i]+"   ");
            }
        }

        // print an array of longs to screen
        // No line returns except at the end
        public static void print(long[] aa){
            for(int i=0; i<aa.length; i++){
                System.out.print(aa[i]+"   ");
            }
            System.out.println();
        }

        // print an array of longs to screen
        // with line returns
        public static void println(long[] aa){
            for(int i=0; i<aa.length; i++){
                System.out.println(aa[i]+"   ");
            }
        }

        // print an array of shorts to screen
        // No line returns except at the end
        public static void print(short[] aa){
            for(int i=0; i<aa.length; i++){
                System.out.print(aa[i]+"   ");
            }
            System.out.println();
        }

        // print an array of shorts to screen
        // with line returns
        public static void println(short[] aa){
            for(int i=0; i<aa.length; i++){
                System.out.println(aa[i]+"   ");
            }
        }

        // print an array of char to screen
        // No line returns except at the end
        public static void print(char[] aa){
            for(int i=0; i<aa.length; i++){
                System.out.print(aa[i]+"   ");
            }
            System.out.println();
        }

        // print an array of char to screen
        // with line returns
        public static void println(char[] aa){
            for(int i=0; i<aa.length; i++){
                System.out.println(aa[i]+"   ");
            }
        }


        // print an array of bytes to screen
        // No line returns except at the end
        public static void print(byte[] aa){
            for(int i=0; i<aa.length; i++){
                System.out.print(aa[i]+"   ");
            }
            System.out.println();
        }

        // print an array of bytes to screen
        // with line returns
        public static void println(byte[] aa){
            for(int i=0; i<aa.length; i++){
                System.out.println(aa[i]+"   ");
            }
        }


        // print an array of Doubles to screen
        // No line returns except at the end
        public static void print(Double[] aa){
            for(int i=0; i<aa.length; i++){
                System.out.print(aa[i]+"   ");
            }
            System.out.println();
        }

        // print an array of Doubles to screen
        // with line returns
        public static void println(Double[] aa){
            for(int i=0; i<aa.length; i++){
                System.out.println(aa[i]+"   ");
            }
        }

        // print an array of Floats to screen
        // No line returns except at the end
        public static void print(Float[] aa){
            for(int i=0; i<aa.length; i++){
                System.out.print(aa[i]+"   ");
            }
            System.out.println();
        }

        // print an array of Floats to screen
        // with line returns
        public static void println(Float[] aa){
            for(int i=0; i<aa.length; i++){
                System.out.println(aa[i]+"   ");
            }
        }

        // print an array of Integers to screen
        // No line returns except at the end
        public static void print(Integer[] aa){
            for(int i=0; i<aa.length; i++){
                System.out.print(aa[i]+"   ");
            }
            System.out.println();
        }

        // print an array of Integers to screen
        // with line returns
        public static void println(Integer[] aa){
            for(int i=0; i<aa.length; i++){
                System.out.println(aa[i]+"   ");
            }
        }

        // print an array of Longs to screen
        // No line returns except at the end
        public static void print(Long[] aa){
            for(int i=0; i<aa.length; i++){
                System.out.print(aa[i]+"   ");
            }
            System.out.println();
        }

        // print an array of Longs to screen
        // with line returns
        public static void println(Long[] aa){
            for(int i=0; i<aa.length; i++){
                System.out.println(aa[i]+"   ");
            }
        }

        // print an array of Shorts to screen
        // No line returns except at the end
        public static void print(Short[] aa){
            for(int i=0; i<aa.length; i++){
                System.out.print(aa[i]+"   ");
            }
            System.out.println();
        }

        // print an array of Shorts to screen
        // with line returns
        public static void println(Short[] aa){
            for(int i=0; i<aa.length; i++){
                System.out.println(aa[i]+"   ");
            }
        }

        // print an array of Character to screen
        // No line returns except at the end
        public static void print(Character[] aa){
            for(int i=0; i<aa.length; i++){
                System.out.print(aa[i]+"   ");
            }
            System.out.println();
        }

        // print an array of Character to screen
        // with line returns
        public static void println(Character[] aa){
            for(int i=0; i<aa.length; i++){
                System.out.println(aa[i]+"   ");
            }
        }


        // print an array of Bytes to screen
        // No line returns except at the end
        public static void print(Byte[] aa){
            for(int i=0; i<aa.length; i++){
                System.out.print(aa[i]+"   ");
            }
            System.out.println();
        }

        // print an array of Bytes to screen
        // with line returns
        public static void println(Byte[] aa){
            for(int i=0; i<aa.length; i++){
                System.out.println(aa[i]+"   ");
            }
        }

        // print an array of String to screen
        // No line returns except at the end
        public static void print(String[] aa){
            for(int i=0; i<aa.length; i++){
                System.out.print(aa[i]+"   ");
            }
            System.out.println();
        }

        // print an array of Strings to screen
        // with line returns
        public static void println(String[] aa){
            for(int i=0; i<aa.length; i++){
                System.out.println(aa[i]+"   ");
            }
        }

        // print an array of Complex to screen
        // No line returns except at the end
        public static void print(Complex[] aa){
            for(int i=0; i<aa.length; i++){
                System.out.print(aa[i]+"   ");
            }
            System.out.println();
        }

        // print an array of Complex to screen
        // with line returns
        public static void println(Complex[] aa){
            for(int i=0; i<aa.length; i++){
                System.out.println(aa[i]+"   ");
            }
        }

        // print an array of Phasor to screen
        // No line returns except at the end
        public static void print(Phasor[] aa){
            for(int i=0; i<aa.length; i++){
                System.out.print(aa[i]+"   ");
            }
            System.out.println();
        }

        // print an array of Phasor to screen
        // with line returns
        public static void println(Phasor[] aa){
            for(int i=0; i<aa.length; i++){
                System.out.println(aa[i]+"   ");
            }
        }


        // print an array of BigDecimal to screen
        // No line returns except at the end
        public static void print(BigDecimal[] aa){
            for(int i=0; i<aa.length; i++){
                System.out.print(aa[i]+"   ");
            }
            System.out.println();
        }

        // print an array of BigDecimal to screen
        // with line returns
        public static void println(BigDecimal[] aa){
            for(int i=0; i<aa.length; i++){
                System.out.println(aa[i]+"   ");
            }
        }

        // print an array of BigInteger to screen
        // No line returns except at the end
        public static void print(BigInteger[] aa){
            for(int i=0; i<aa.length; i++){
                System.out.print(aa[i]+"   ");
            }
            System.out.println();
        }

        // print an array of BigInteger to screen
        // with line returns
        public static void println(BigInteger[] aa){
            for(int i=0; i<aa.length; i++){
                System.out.println(aa[i]+"   ");
            }
        }


        // 2D ARRAYS
        // print a 2D array of doubles to screen
        public static void print(double[][] aa){
            for(int i=0; i<aa.length; i++){
                PrintToScreen.print(aa[i]);
            }
        }

        // print a 2D array of floats to screen
        public static void print(float[][] aa){
            for(int i=0; i<aa.length; i++){
                PrintToScreen.print(aa[i]);
            }
        }

        // print a 2D array of ints to screen
        public static void print(int[][] aa){
            for(int i=0; i<aa.length; i++){
                PrintToScreen.print(aa[i]);
            }
        }

        // print a 2D array of longs to screen
        public static void print(long[][] aa){
            for(int i=0; i<aa.length; i++){
                PrintToScreen.print(aa[i]);
            }
        }
        // print a 2D array of chars to screen
        public static void print(char[][] aa){
            for(int i=0; i<aa.length; i++){
                PrintToScreen.print(aa[i]);
            }
        }

        // print a 2D array of bytes to screen
        public static void print(byte[][] aa){
            for(int i=0; i<aa.length; i++){
                PrintToScreen.print(aa[i]);
            }
        }

        // print a 2D array of shorts to screen
        public static void print(short[][] aa){
            for(int i=0; i<aa.length; i++){
                PrintToScreen.print(aa[i]);
            }
        }



        // print a 2D array of Doubles to screen
        public static void print(Double[][] aa){
            for(int i=0; i<aa.length; i++){
                PrintToScreen.print(aa[i]);
            }
        }

        // print a 2D array of Floats to screen
        public static void print(Float[][] aa){
            for(int i=0; i<aa.length; i++){
                PrintToScreen.print(aa[i]);
            }
        }

        // print a 2D array of Integers to screen
        public static void print(Integer[][] aa){
            for(int i=0; i<aa.length; i++){
                PrintToScreen.print(aa[i]);
            }
        }

        // print a 2D array of Longs to screen
        public static void print(Long[][] aa){
            for(int i=0; i<aa.length; i++){
                PrintToScreen.print(aa[i]);
            }
        }
        // print a 2D array of Characters to screen
        public static void print(Character[][] aa){
            for(int i=0; i<aa.length; i++){
                PrintToScreen.print(aa[i]);
            }
        }

        // print a 2D array of Bytes to screen
        public static void print(Byte[][] aa){
            for(int i=0; i<aa.length; i++){
                PrintToScreen.print(aa[i]);
            }
        }

        // print a 2D array of Shorts to screen
        public static void print(Short[][] aa){
            for(int i=0; i<aa.length; i++){
                PrintToScreen.print(aa[i]);
            }
        }

        // print a 2D array of Strings to screen
        public static void print(String[][] aa){
            for(int i=0; i<aa.length; i++){
                PrintToScreen.print(aa[i]);
            }
        }

        // print a 2D array of Complex to screen
        public static void print(Complex[][] aa){
            for(int i=0; i<aa.length; i++){
                Complex.print(aa[i]);
            }
        }

        // print a 2D array of Phasor to screen
        public static void print(Phasor[][] aa){
            for(int i=0; i<aa.length; i++){
                Phasor.print(aa[i]);
            }
        }

        // print a 2D array of BigDecimal to screen
        public static void print(BigDecimal[][] aa){
            for(int i=0; i<aa.length; i++){
                PrintToScreen.print(aa[i]);
            }
        }

        // print a 2D array of BigInteger to screen
        public static void print(BigInteger[][] aa){
            for(int i=0; i<aa.length; i++){
                PrintToScreen.print(aa[i]);
            }
        }
}



