# -*- coding: utf-8 -*-
#
# File: commonsdialog.py
#
# Copyright (c) 2011 by Model Driven Development sl and Antonio Carrasco Valero
#
# GNU General Public License (GPL)
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
# 02110-1301, USA.
#
#

__author__ = """Antonio Carrasco Valero
Model Driven Development sl and Antonio Carrasco Valero
<carrasco@modeldd.org>
Victor Acevedo Royer <vacevedo@gvsig.com> <vacevedor@gmail.com>
"""
__docformat__ = 'plaintext'


from javax.swing import JFileChooser
from javax.swing.filechooser import FileNameExtensionFilter

#from org.gvsig.app import ApplicationLocator      

from org.gvsig.andami.ui.mdiFrame import DefaultThreadSafeDialogs

#====================================
# SWING

#
#messageType options
FORBIDEN = 0
IDEA= 1
WARNING= 2
QUESTION= 3

#
#Confirmdialog optionType Options
YES_NO = 0
YES_NO_CANCEL = 1
ACEPT_CANCEL = 2

#filechooser options
OPEN_FILE = 0
OPEN_DIRECTORY = 1
SAVE_FILE = 2

#filechooser selectionMode
FILES_ONLY = JFileChooser.FILES_ONLY
DIRECTORIES_ONLY = JFileChooser.DIRECTORIES_ONLY


def msgbox(message, title="", messageType=IDEA):
    """Shows a message dialog with ok button only
    :param message: text to present in the dialog
    :param title: title of the dialog
    :param messageType: type of icon to use.
    """
    DefaultThreadSafeDialogs().messageDialog(message, title, messageType)

   
def inputbox(message, title="", messageType=IDEA, initialValue=""):
    """
    Shows a input dialog.
    :param message: text to present in the dialog
    :param title: title of the dialog
    :messageType: type of icon to use
    :initialValue: Initial value of the inputbox  
    """
    return DefaultThreadSafeDialogs().inputDialog(message, title, 
        messageType, initialValue) 
  
  
def confirmDialog(message, title="", optionType=YES_NO, messageType=IDEA):
    """
    Create a message dialog with options button
    :param message: text to present in the dialog
    :param title: title of the dialog
    :optionType: bottons to show
    :param messageType: type of icon to use.    
    """
    #0: yes/no option
    #1: yes/no/cancelar
    #2: accept/cancel
    return DefaultThreadSafeDialogs().confirmDialog(message, title, 
        optionType, messageType) 

def filechooser(option, title="", initialPath=None, 
        multiselection=False, filter = None, fileHidingEnabled=True):
    """
    Allows configuration parameters to filechooser dialogs
    :int option: file chooser selection mode. Allowed values:
        OPEN_FILE, OPEN_DIRECTORY, SAVE_FILE
    :String title: Window title
    :String initialPath: Initial path to the directory to open in the dialog
    :boolean multiselection: Allow select more than one object.
    :String[] filter: list of acepted extension files ("jpg", "png", "gif")
    :boolean fileHidingEnabled: True if hidden files are not displayed
    """ 
    #
    #Values for open files dialog
    dialogType = JFileChooser.OPEN_DIALOG
    selectionMode = FILES_ONLY
    
    if option == SAVE_FILE:
        dialogType = JFileChooser.SAVE_DIALOG
    elif option == OPEN_DIRECTORY:
        selectionMode = DIRECTORIES_ONLY

    initialPath = getJavaFile(initialPath)
   
    if filter:
        filter = FileNameExtensionFilter("Files", filter)
       
    return DefaultThreadSafeDialogs().showChooserDialog(
            title,
            dialogType,
            selectionMode,
            multiselection,
            initialPath,
            filter,
            fileHidingEnabled)
   
def openFileDialog(title='', initialPath=None):
    """
    Shows a window dialog to choose one file. 
    :param title: Window title. Default ''
    :type title: string
    :param initialPath: Initial path to open in window dialog
    :type initialPath: string
    """
  
    return DefaultThreadSafeDialogs().showOpenFileDialog(
        title, 
        getJavaFile(initialPath))

def openFolderDialog(title='', initialPath=None):
    """
    Shows a window dialog to choose one folder. 
    :param title: Window title. Default ''
    :type title: string
    :param initialPath: Initial path to open in window dialog
    :type initialPath: string
    """    
  
    return DefaultThreadSafeDialogs().showOpenDirectoryDialog(
        title, 
        getJavaFile(initialPath))
  
def saveFileDialog(title='', initialPath=None):
    """
    Shows a window dialog to choose one file. 
    :param title: Window title. Default ''
    :type title: string
    :param initialPath: Initial path to open in window dialog
    :type initialPath: string
    """    
    
    return DefaultThreadSafeDialogs().showSaveFileDialog(
        title, 
        getJavaFile(initialPath)
    )
  
def getJavaFile(path):
    """Returns a java File using parameter path.
    If path doesn't exists looks for user home folder and if can not find it, 
    returns path will be gvSIG instance directory.
    """
    #
    #Needs because DefaultThreadSafeDialogs files methods use a java File 
    #instance as initialPath parameter
    #
    import os
    import java.io.File as JFile  
  
    if path:
        path = os.path.normpath(path)
        if os.path.exists(path):
            return JFile(path)
        
    if os.environ.has_key('HOME'):
        return JFile(os.environ.get('HOME', os.getcwd()))

    if os.path.exists(os.path.expanduser("~")):
        return JFile(os.path.expanduser("~"))
    
    return JFile(os.getcwd())
    
    