#
# ==========================================================
#
# Declara la clase ToolboxProcess y declara una serie de
# constantes de utilidad para ser usadas en la creacion
# de geoprocesos.
# La clase ToolboxProcess esta pensada para ser usada como
# clase base para crear procesos desde scripting con python.
#
#
from gvsig.uselib import use_plugin

use_plugin("org.gvsig.geoprocess.app.mainplugin")

from org.gvsig.geoprocess.lib.sextante import AbstractSextanteGeoProcess
from es.unex.sextante.outputs import OutputVectorLayer
from es.unex.sextante.dataObjects import IVectorLayer
from es.unex.sextante.additionalInfo import AdditionalInfoNumericalValue
from org.gvsig.geoprocess.lib.api import GeoProcessLocator
from es.unex.sextante.gui.core import SextanteGUI
from org.gvsig.tools.dispose import DisposeUtils
from  es.unex.sextante.core import Sextante


SHAPE_TYPE_POINT = IVectorLayer.SHAPE_TYPE_POINT
SHAPE_TYPE_LINE = IVectorLayer.SHAPE_TYPE_LINE
SHAPE_TYPE_POLYGON = IVectorLayer.SHAPE_TYPE_POLYGON
SHAPE_TYPE_MIXED = IVectorLayer.SHAPE_TYPE_MIXED
SHAPE_TYPE_MULTIPOINT = IVectorLayer.SHAPE_TYPE_MULTIPOINT
SHAPE_TYPE_MULTILINE = IVectorLayer.SHAPE_TYPE_MULTILINE
SHAPE_TYPE_MULTIPOLYGON = IVectorLayer.SHAPE_TYPE_MULTIPOLYGON
SHAPE_TYPE_WRONG = IVectorLayer.SHAPE_TYPE_WRONG
SHAPE_TYPE_UNDEFINED = SHAPE_TYPE_WRONG

NUMERICAL_VALUE_INTEGER = AdditionalInfoNumericalValue.NUMERICAL_VALUE_INTEGER
NUMERICAL_VALUE_DOUBLE = AdditionalInfoNumericalValue.NUMERICAL_VALUE_DOUBLE

class ToolboxProcess(AbstractSextanteGeoProcess):

  def __init__(self):
    self.__maxrange = 0
    self.__countrange = 0

  def getCommandLineName(self):
    """
Este metodo debe ser sobreescrito en Jython para que funcione correctamente el geoproceso.
No se debe sobreescribir en nuestro geoproceso.
    """
    return self.__class__.__name__

  def getNewInstance(self):
    """
Este metodo debe ser sobreescrito en Jython para que funcione correctamente el geoproceso.
No se debe sobreescribir en nuestro geoproceso.
    """
    alg = self.__class__()
    alg.setName(self.getName())
    alg.setGroup(self.getGroup())

    alg.setParameters(self.getParameters().getNewInstance())
    alg.setOutputObjects(self.getOutputObjects().getNewInstance())
    return alg;

  def setRangeOfValues(self,start,end):
    """
Metodo que debe ser invocado para fijar los limites de la iteracion del geoproceso.
Se encarga de actualizar las barras de progreso asociadas a nuestros geoprocesos.
    """
    self.__maxrange = end
    self.__countrange = 0
    self.getStatus().setRangeOfValues(1,end)
    self.setProgress(0, end)

  def next(self):
    """
Incrementa el progreso de nuestro proceso.
    """
    self.__countrange+=1
    self.setCurValue(self.__countrange)

  def isCanceled(self):
    """
Nos informa si el usuario a cancelado el proceso.
    """
    return self.getTaskMonitor().isCanceled()

  def setCurValue(self,current):
    """
Fija el progreso de nuestro proceso en el valor indicado como parametro.
    """
    self.getStatus().setCurValue(current)
    self.setProgress(current, self.__maxrange);

  def createNewFeature(self, store, feature=None):
    """
Crea una nueva feature o entidad asociada al almacen (store) pasado como parametro.
Esta nueva feature podra ser insertada en el almancen inficado como parametro.
Si se ha indicado como parametro una feature, se copiaran los datos de esta sobre la nueva.
    """
    newfeature = store.createNewFeature()
    if feature!=None:
      for field in newfeature.getType().iterator():
        try:
          value = feature.get(field.getName())
          newfeature.set(field.getName(), value)
        except:
          # Ignoramos errores ya que es facil que hayan campo que no existen en una u otra
          # feature o que no son del mismo tipo.
          pass
    return newfeature

  def selfregister(self, groupname):
    """
Registra el geoproceso en la lista de geoprocesos disponibles.
    """
    Sextante.addGeoalgorithm(groupname,self.__class__())

  def updateToolbox(self):
    """
Fuerza que se actualize el interface de usuario de la Toolbox.
    """
    SextanteGUI.getGUIFactory().updateToolbox()

