

def use_plugin(pluginName):
  from org.gvsig.andami import PluginsLocator

  pluginsManager = PluginsLocator.getManager()
  other = pluginsManager.getPlugin(pluginName)
  scripting = pluginsManager.getPlugin("org.gvsig.scripting.app.mainplugin")
  scripting.addDependencyWithPlugin(other)

def use_jar(fname):
  from org.gvsig.scripting.app.extension import ScriptingExtension

  ScriptingExtension.add_classpath(fname)

def use_libs(folder, isglobal=False):
  from org.gvsig.scripting import ScriptingLocator
  import sys
  if not folder in sys.path:
    sys.path.append(folder)
    if isglobal:
      manager = ScriptingLocator.getManager()
      global_path = manager.getProperty("jython.global.path")
      if global_path == None:
        global_path = list()
        global_path.append(folder)    
        manager.setProperty("jython.global.path",global_path)
      elif not folder in global_path:
        global_path.append(folder)

def use_jars(base):
  import os, os.path

  if os.path.isfile(base):
    base = os.path.dirname(base)
  for f in os.listdir(base):
    if f.endswith(".jar"):
      pathname = os.path.join(base,f)
      use_jar(pathname)
