# encoding: utf-8

from gvsig import currentLayer, currentView
from gvsig.commonsdialog import msgbox, inputbox, QUESTION

"""
Para probar este ejemplo cargue la capa MANZANAS_POB de la carpeta
data y seleccionela en el TOC
"""

def calcular_sumatorio(mapContext, layer, fieldname):
  encuadre = mapContext.getViewPort().getEnvelope().getGeometry()
  lineas = layer.getFeatureStore().getFeatureSet().iterator()
  suma = 0
  for linea in lineas:
    g = linea.getDefaultGeometry()
    if encuadre.intersects(g) :
      suma += int(linea.get(fieldname))
  print "Sumatorio de %s: %s" % (fieldname, suma)

def main(*args):
  if currentView() == None:
    msgbox("Debera tener una vista abierta y activa")
    return
  mapContext = currentView().getMapContext()
 
  layer = currentLayer()
  if layer == None:
    msgbox("Debera tener seleccionada la capa sobre la que desea trabajar")
    return
  fieldname = inputbox(
    "Introduzca el nombre del campo para calcular el sumatorio",
    "Nombre de campo",
    QUESTION,
    "pob_total"
  )
  if fieldname in ("",None):
    msgbox("Operacion cancelada")
    return
  calcular_sumatorio(mapContext, layer, fieldname)

