# encoding: utf-8

from gvsig import currentView, currentLayer
from gvsig.commonsdialog import msgbox, inputbox, QUESTION

from org.gvsig.fmap.mapcontext.events.listeners import ViewPortListener

"""
Para probar este ejemplo cargue la capa MANZANAS_POB de la carpeta
data y seleccionela en el TOC

Ojo!!!!, que este script añade un listener que no elimina nunca,
con lo que para abortarlo tendremos que cerrar la vista y eliminarla
del proyecto.
Usar este script solo con fines didacticos.

"""

class MonitorSuma(ViewPortListener):

  def __init__(self, mapContext, layer, fieldname):
    self.mapContext = mapContext
    self.layer = layer
    self.fieldname = fieldname
    self.calcular_sumatorio()
    mapContext.getViewPort().addViewPortListener(self)

  def backColorChanged(self,*args):
    pass

  def extentChanged(self,*args):
    self.calcular_sumatorio()

  def projectionChanged(self,*args):
    pass

  def calcular_sumatorio(self):
    encuadre = self.mapContext.getViewPort().getEnvelope().getGeometry()
    lineas = self.layer.getFeatureStore().getFeatureSet().iterator()
    suma = 0
    for linea in lineas:
      g = linea.getDefaultGeometry()
      if encuadre.intersects(g) :
        suma += int(linea.get(self.fieldname))
    print "Sumatorio de %s: %s" % (self.fieldname, suma)

def main(*args):
  if currentView() == None:
    msgbox("Debera tener una vista abierta y activa")
    return
  mapContext = currentView().getMapContext()
 
  layer = currentLayer()
  if layer == None:
    msgbox("Debera tener seleccionada la capa sobre la que desea trabajar")
    return
  fieldname = inputbox(
    "Introduzca el nombre del campo para calcular el sumatorio",
    "Nombre de campo",
    QUESTION,
    "pob_total"
  )
  if fieldname in ("",None):
    msgbox("Operacion cancelada")
    return
  monitor = MonitorSuma(mapContext, layer, fieldname)
