<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:transform version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:template name="write-data-type">
    <xsl:param name="type-id"/>
    <xsl:param name="precision"/>
    <xsl:param name="scale"/>
    <xsl:param name="dbms-type"/>
    <xsl:param name="auto-inc"/>
    
<!--     <xsl:message>First 4 of dbms-type: <xsl:value-of select="substring($dbms-type, 1, 4)" /></xsl:message>  -->
    
    <xsl:choose>                        <!-- Oracle / PostgreSQL -->
      <xsl:when test="$type-id = 2005"> <!-- CLOB / TEXT -->
        <xsl:text>CLOB</xsl:text>
      </xsl:when>
      <xsl:when test="$type-id = 2011"> <!-- NCLOB / TEXT -->
        <xsl:text>NCLOB</xsl:text>
      </xsl:when>
      <xsl:when test="$type-id = 2004 or $type-id = -3 or $type-id = -4"> <!-- BLOB / BYTEA -->
        <xsl:text>BLOB</xsl:text>
      </xsl:when>
      <xsl:when test="$type-id = 93">
        <xsl:text>TIMESTAMP</xsl:text>
      </xsl:when>
      <xsl:when test="$type-id = 2014">
        <xsl:text>TIMESTAMP WITH LOCAL TIME ZONE</xsl:text>
      </xsl:when>
      <xsl:when test="$type-id = 92"> <!-- TIMESTAMP / TIME -->
        <xsl:text>TIME</xsl:text>
      </xsl:when>
      <xsl:when test="$type-id = 91">
        <xsl:text>DATE</xsl:text>
      </xsl:when>
      <xsl:when test="$type-id = 1 or $type-id = -15">
         <xsl:text>CHAR(<xsl:value-of select="$precision"/>)</xsl:text>
      </xsl:when>
      <xsl:when test="$type-id = 4">
        <xsl:choose>
          <xsl:when test="$auto-inc = 'true'">
	        <xsl:text>INT GENERATED BY DEFAULT ON NULL AS IDENTITY</xsl:text>
	      </xsl:when>
	      <xsl:otherwise>
        	<xsl:text>INT</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:when test="$type-id = -5">
        <xsl:choose>
          <xsl:when test="$auto-inc = 'true'">
	        <xsl:text>NUMBER GENERATED BY DEFAULT ON NULL AS IDENTITY</xsl:text>
	      </xsl:when>
	      <xsl:otherwise>
        	<xsl:text>NUMBER</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:when test="$type-id = 5 or $type-id = -6">
        <xsl:text>NUMBER(5)</xsl:text>
      </xsl:when>
      <xsl:when test="$type-id = 8">
        <xsl:text>DOUBLE PRECISION</xsl:text>
      </xsl:when>
      <xsl:when test="$type-id = 7">
        <xsl:text>REAL</xsl:text>
      </xsl:when>
      <xsl:when test="$type-id = 6">
        <xsl:text>FLOAT</xsl:text>
      </xsl:when>
      <xsl:when test="$type-id = 16 or $type-id = -7">
        <xsl:text>NUMBER(1)</xsl:text>
      </xsl:when>
      <xsl:when test="$type-id = 2 or $type-id = 3">
        <xsl:if test="$scale &gt; 0">
          <xsl:text>NUMBER(</xsl:text><xsl:value-of select="$precision"/><xsl:text>,</xsl:text><xsl:value-of select="$scale"/><xsl:text>)</xsl:text>
        </xsl:if>
        <xsl:if test="$scale = 0 or $scale = ''">
        	<!-- HINT: bei Oracle verwalteten Datenbanken luft bei NUMBER das Programm immer hier in diesen Switch -->
        	<xsl:choose>
        		<xsl:when test="$precision = 1">
        			<xsl:text>NUMBER(1)</xsl:text>
        		</xsl:when>
        		<xsl:when test="$precision &lt; 6">
        			<xsl:text>NUMBER(5)</xsl:text>
        		</xsl:when>
        		<xsl:when test="$precision &lt; 11">
		            <xsl:choose>
			          <xsl:when test="$auto-inc = 'true'">
				        <xsl:text>INT GENERATED BY DEFAULT ON NULL AS IDENTITY</xsl:text>
				      </xsl:when>
				      <xsl:otherwise>
			        	<xsl:text>INT</xsl:text>
			          </xsl:otherwise>
			        </xsl:choose>
		        </xsl:when>
		        <xsl:otherwise>
		        	<xsl:choose>
			          <xsl:when test="$auto-inc = 'true'">
				        <xsl:text>NUMBER GENERATED BY DEFAULT ON NULL AS IDENTITY</xsl:text>
				      </xsl:when>
				      <xsl:otherwise>
			        	<xsl:text>NUMBER</xsl:text>
			          </xsl:otherwise>
			        </xsl:choose>
		        </xsl:otherwise>
        	</xsl:choose>
        </xsl:if>
      </xsl:when>
      <xsl:when test="$type-id = 12 or $type-id = -9"> <!-- -9 is NVARCHAR -->
        <!-- maximum varchar2 size in Oracle is 4000 bytes / characters -->
            <xsl:if test="$precision &lt;= 4000">
              <xsl:text>VARCHAR2(</xsl:text><xsl:value-of select="$precision"/><xsl:text> CHAR)</xsl:text>
            </xsl:if>
            <xsl:if test="$precision &gt; 4000">
              <xsl:text>CLOB</xsl:text>
            </xsl:if>
      </xsl:when>
      <xsl:when test="$type-id = 1111 and substring($dbms-type, 1, 4) = 'json'"> <!-- Oracle has no data type JSON or JSONB (yet) -->
      	<xsl:text>CLOB</xsl:text>
      </xsl:when>
      <xsl:otherwise>
          <xsl:value-of select="$dbms-type"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
</xsl:transform>