@begin createRepositoryIndex1
create index idx_data_1 on VCSGISREPO_DATA (COD_ENTITY ASC, DAT_REVNUMBER ASC)
@end createRepositoryIndex1

@begin createRepositoryIndex2
create index idx_data_2 on VCSGISREPO_DATA (DAT_FEATURERELATEDCODE ASC, DAT_REVNUMBER ASC, DAT_OPERATION ASC)
@end createRepositoryIndex2

@begin getDataOfEntityFromRevisionNumber
@param revision_number
@param entity_code
@param data_table_name
select * from "%data_table_name$s" where
        "%data_table_name$s"."COD_ENTITY" = '%entity_code$s' AND
        "%data_table_name$s"."COD_DATA" in (
	select 
	  MIN("VCSGISREPO_DATA1"."COD_DATA")
	from "%data_table_name$s" "VCSGISREPO_DATA1"
	  left join "%data_table_name$s" "VCSGISREPO_DATA2" on
	    ("VCSGISREPO_DATA1"."DAT_FEATURERELATEDCODE" = "VCSGISREPO_DATA2"."DAT_FEATURERELATEDCODE" and "VCSGISREPO_DATA1"."COD_ENTITY" = "VCSGISREPO_DATA2"."COD_ENTITY")
	    and "VCSGISREPO_DATA2"."DAT_REVNUMBER" > %revision_number$d 
	where 
	  "VCSGISREPO_DATA1"."COD_ENTITY" = '%entity_code$s'
	  and "VCSGISREPO_DATA1"."DAT_REVNUMBER" > %revision_number$d   
	group by "VCSGISREPO_DATA1"."DAT_FEATURERELATEDCODE", "VCSGISREPO_DATA1"."DAT_REVNUMBER", "VCSGISREPO_DATA1"."DAT_OPERATION"
	having not (
	  ("VCSGISREPO_DATA1"."DAT_OPERATION" = 0 and MAX("VCSGISREPO_DATA2"."DAT_OPERATION") = 2 )
	  or  ("VCSGISREPO_DATA1"."DAT_OPERATION" = 1 and MIN("VCSGISREPO_DATA2"."DAT_OPERATION") = 0 )
	  or  ("VCSGISREPO_DATA1"."DAT_OPERATION" = 2 and (MIN("VCSGISREPO_DATA2"."DAT_OPERATION") = 0  or max("VCSGISREPO_DATA2"."DAT_OPERATION") = 1 or min("VCSGISREPO_DATA2"."DAT_OPERATION") = 1 ))
	  or  ("VCSGISREPO_DATA1"."DAT_OPERATION" = 0 and MIN("VCSGISREPO_DATA2"."DAT_OPERATION") <> 0  and "VCSGISREPO_DATA1"."DAT_REVNUMBER" < max("VCSGISREPO_DATA2"."DAT_REVNUMBER"))
	  or  ("VCSGISREPO_DATA1"."DAT_OPERATION" = 1 and (max("VCSGISREPO_DATA2"."DAT_OPERATION") = 1 or min("VCSGISREPO_DATA2"."DAT_OPERATION") = 1) and "VCSGISREPO_DATA1"."DAT_REVNUMBER" < max("VCSGISREPO_DATA2"."DAT_REVNUMBER"))
	  or  ("VCSGISREPO_DATA1"."DAT_OPERATION" = 2 and max("VCSGISREPO_DATA2"."DAT_OPERATION") = 2 and "VCSGISREPO_DATA1"."DAT_REVNUMBER" < max("VCSGISREPO_DATA2"."DAT_REVNUMBER"))  )
)
order by "VCSGISREPO_DATA"."DAT_OPERATION" desc
@end getDataOfEntityFromRevisionNumber

@begin getDataOfEntityToRevisionNumber
@param revision_number
@param entity_code
@param data_table_name
select * from "%data_table_name$s" where 
        "%data_table_name$s"."COD_ENTITY" = '%entity_code$s' AND
        "%data_table_name$s"."COD_DATA" in (
	select 
	  MIN("VCSGISREPO_DATA1"."COD_DATA")
	from "%data_table_name$s" "VCSGISREPO_DATA1"
	  left join "%data_table_name$s" "VCSGISREPO_DATA2" on
	    ("VCSGISREPO_DATA1"."DAT_FEATURERELATEDCODE" = "VCSGISREPO_DATA2"."DAT_FEATURERELATEDCODE" and "VCSGISREPO_DATA1"."COD_ENTITY" = "VCSGISREPO_DATA2"."COD_ENTITY")
	    and "VCSGISREPO_DATA2"."DAT_REVNUMBER" <= %revision_number$d 
	where 
	  "VCSGISREPO_DATA1"."COD_ENTITY" = '%entity_code$s'
	  and "VCSGISREPO_DATA1"."DAT_REVNUMBER" <= %revision_number$d   
	group by "VCSGISREPO_DATA1"."DAT_FEATURERELATEDCODE", "VCSGISREPO_DATA1"."DAT_REVNUMBER", "VCSGISREPO_DATA1"."DAT_OPERATION"
	having not (
	  ("VCSGISREPO_DATA1"."DAT_OPERATION" = 0 and MAX("VCSGISREPO_DATA2"."DAT_OPERATION") = 2 )
	  or  ("VCSGISREPO_DATA1"."DAT_OPERATION" = 1 and MIN("VCSGISREPO_DATA2"."DAT_OPERATION") = 0 )
	  or  ("VCSGISREPO_DATA1"."DAT_OPERATION" = 2 and (MIN("VCSGISREPO_DATA2"."DAT_OPERATION") = 0  or max("VCSGISREPO_DATA2"."DAT_OPERATION") = 1 or min("VCSGISREPO_DATA2"."DAT_OPERATION") = 1 ))
	  or  ("VCSGISREPO_DATA1"."DAT_OPERATION" = 0 and MIN("VCSGISREPO_DATA2"."DAT_OPERATION") <> 0  and "VCSGISREPO_DATA1"."DAT_REVNUMBER" < max("VCSGISREPO_DATA2"."DAT_REVNUMBER"))
	  or  ("VCSGISREPO_DATA1"."DAT_OPERATION" = 1 and (max("VCSGISREPO_DATA2"."DAT_OPERATION") = 1 or min("VCSGISREPO_DATA2"."DAT_OPERATION") = 1) and "VCSGISREPO_DATA1"."DAT_REVNUMBER" < max("VCSGISREPO_DATA2"."DAT_REVNUMBER"))
	  or  ("VCSGISREPO_DATA1"."DAT_OPERATION" = 2 and max("VCSGISREPO_DATA2"."DAT_OPERATION") = 2 and "VCSGISREPO_DATA1"."DAT_REVNUMBER" < max("VCSGISREPO_DATA2"."DAT_REVNUMBER"))  )
)
order by "VCSGISREPO_DATA"."DAT_OPERATION" desc
@end getDataOfEntityToRevisionNumber


@begin getDataOfEntityToRevisionNumberAndRoi
@param revision_number
@param entity_code
@param roi
@param data_table_name
select * from "%data_table_name$s" where 
        "%data_table_name$s"."COD_ENTITY" = '%entity_code$s'
        and (SDO_RELATE("VCSGISREPO_DATA"."DAT_GEOM",%roi$s,'mask=ANYINTERACT') = 'TRUE')
        and "%data_table_name$s"."COD_DATA" in (
	select 
	  MIN("VCSGISREPO_DATA1"."COD_DATA")
	from "%data_table_name$s" "VCSGISREPO_DATA1"
	  left join "%data_table_name$s" "VCSGISREPO_DATA2" on
	    ("VCSGISREPO_DATA1"."DAT_FEATURERELATEDCODE" = "VCSGISREPO_DATA2"."DAT_FEATURERELATEDCODE" and "VCSGISREPO_DATA1"."COD_ENTITY" = "VCSGISREPO_DATA2"."COD_ENTITY")
	    and "VCSGISREPO_DATA2"."DAT_REVNUMBER" <= %revision_number$d 
	where 
	  "VCSGISREPO_DATA1"."COD_ENTITY" = '%entity_code$s'
	  and "VCSGISREPO_DATA1"."DAT_REVNUMBER" <= %revision_number$d   
          and (SDO_RELATE("VCSGISREPO_DATA1"."DAT_GEOM",%roi$s,'mask=ANYINTERACT') = 'TRUE') 
	group by "VCSGISREPO_DATA1"."DAT_FEATURERELATEDCODE", "VCSGISREPO_DATA1"."DAT_REVNUMBER", "VCSGISREPO_DATA1"."DAT_OPERATION"
	having not (
	  ("VCSGISREPO_DATA1"."DAT_OPERATION" = 0 and MAX("VCSGISREPO_DATA2"."DAT_OPERATION") = 2 )
	  or  ("VCSGISREPO_DATA1"."DAT_OPERATION" = 1 and MIN("VCSGISREPO_DATA2"."DAT_OPERATION") = 0 )
	  or  ("VCSGISREPO_DATA1"."DAT_OPERATION" = 2 and (MIN("VCSGISREPO_DATA2"."DAT_OPERATION") = 0  or max("VCSGISREPO_DATA2"."DAT_OPERATION") = 1 or min("VCSGISREPO_DATA2"."DAT_OPERATION") = 1 ))
	  or  ("VCSGISREPO_DATA1"."DAT_OPERATION" = 0 and MIN("VCSGISREPO_DATA2"."DAT_OPERATION") <> 0  and "VCSGISREPO_DATA1"."DAT_REVNUMBER" < max("VCSGISREPO_DATA2"."DAT_REVNUMBER"))
	  or  ("VCSGISREPO_DATA1"."DAT_OPERATION" = 1 and (max("VCSGISREPO_DATA2"."DAT_OPERATION") = 1 or min("VCSGISREPO_DATA2"."DAT_OPERATION") = 1) and "VCSGISREPO_DATA1"."DAT_REVNUMBER" < max("VCSGISREPO_DATA2"."DAT_REVNUMBER"))
	  or  ("VCSGISREPO_DATA1"."DAT_OPERATION" = 2 and max("VCSGISREPO_DATA2"."DAT_OPERATION") = 2 and "VCSGISREPO_DATA1"."DAT_REVNUMBER" < max("VCSGISREPO_DATA2"."DAT_REVNUMBER"))  )
)
order by "VCSGISREPO_DATA"."DAT_OPERATION" desc
@end getDataOfEntityToRevisionNumberAndRoi

@begin getDataOfEntityFromEfectiveDate
@param entity_code
@param efective_date
@param data_table_name
select * from "%data_table_name$s" where 
        "%data_table_name$s"."COD_ENTITY" = '%entity_code$s' AND
        "%data_table_name$s"."COD_DATA" in (
	select 
	  MIN("VCSGISREPO_DATA1"."COD_DATA")
	from "%data_table_name$s" "VCSGISREPO_DATA1"
	  left join "%data_table_name$s" "VCSGISREPO_DATA2" on
	    ("VCSGISREPO_DATA1"."DAT_FEATURERELATEDCODE" = "VCSGISREPO_DATA2"."DAT_FEATURERELATEDCODE" and "VCSGISREPO_DATA1"."COD_ENTITY" = "VCSGISREPO_DATA2"."COD_ENTITY")
	    and "VCSGISREPO_DATA2"."DAT_EFECTIVEDATE" <= to_date('%efective_date$s', 'YYYY-MM-DD HH24:MI:SS') 
	where 
	  "VCSGISREPO_DATA1"."COD_ENTITY" = '%entity_code$s'
	  and "VCSGISREPO_DATA1"."DAT_EFECTIVEDATE" <= to_date('%efective_date$s', 'YYYY-MM-DD HH24:MI:SS')   
	group by "VCSGISREPO_DATA1"."DAT_FEATURERELATEDCODE", "VCSGISREPO_DATA1"."DAT_EFECTIVEDATE", "VCSGISREPO_DATA1"."DAT_REVNUMBER", "VCSGISREPO_DATA1"."DAT_OPERATION"
	having not (
	  ("VCSGISREPO_DATA1"."DAT_OPERATION" = 0 )
	  or  ("VCSGISREPO_DATA1"."DAT_OPERATION" = 1 and MIN("VCSGISREPO_DATA2"."DAT_OPERATION") = 0 )
	  or  ("VCSGISREPO_DATA1"."DAT_OPERATION" = 2 and (MIN("VCSGISREPO_DATA2"."DAT_OPERATION") = 0  or max("VCSGISREPO_DATA2"."DAT_OPERATION") = 1 or min("VCSGISREPO_DATA2"."DAT_OPERATION") = 1 ))
	  or  ("VCSGISREPO_DATA1"."DAT_OPERATION" = 1 and (max("VCSGISREPO_DATA2"."DAT_OPERATION") = 1 or min("VCSGISREPO_DATA2"."DAT_OPERATION") = 1) and "VCSGISREPO_DATA1"."DAT_EFECTIVEDATE" <= max("VCSGISREPO_DATA2"."DAT_EFECTIVEDATE") and "VCSGISREPO_DATA1"."DAT_REVNUMBER" <> max("VCSGISREPO_DATA2"."DAT_REVNUMBER"))
	  or  ("VCSGISREPO_DATA1"."DAT_OPERATION" = 2 and max("VCSGISREPO_DATA2"."DAT_OPERATION") = 2 and "VCSGISREPO_DATA1"."DAT_EFECTIVEDATE" <= max("VCSGISREPO_DATA2"."DAT_EFECTIVEDATE") and "VCSGISREPO_DATA1"."DAT_REVNUMBER" <> max("VCSGISREPO_DATA2"."DAT_REVNUMBER"))  )
)
@end getDataOfEntityFromEfectiveDate

@begin getDataOfEntityFromEfectiveDateAndRoi
@param entity_code
@param efective_date
@param roi
@param data_table_name
@const DELETE=0
@const UPDATE=1
@const INSERT=2
select * from "%data_table_name$s" where 
        "%data_table_name$s"."COD_ENTITY" = '%entity_code$s'
        and (SDO_RELATE("VCSGISREPO_DATA"."DAT_GEOM",%roi$s,'mask=ANYINTERACT') = 'TRUE') 
        and "%data_table_name$s"."COD_DATA" in (
	select 
	  MIN("VCSGISREPO_DATA1"."COD_DATA")
	from "%data_table_name$s" "VCSGISREPO_DATA1"
	  left join "%data_table_name$s" "VCSGISREPO_DATA2" on
	    ("VCSGISREPO_DATA1"."DAT_FEATURERELATEDCODE" = "VCSGISREPO_DATA2"."DAT_FEATURERELATEDCODE" and "VCSGISREPO_DATA1"."COD_ENTITY" = "VCSGISREPO_DATA2"."COD_ENTITY")
	    and "VCSGISREPO_DATA2"."DAT_EFECTIVEDATE" <= to_date('%efective_date$s', 'YYYY-MM-DD HH24:MI:SS') 
	where 
	  "VCSGISREPO_DATA1"."COD_ENTITY" = '%entity_code$s'
	  and "VCSGISREPO_DATA1"."DAT_EFECTIVEDATE" <= to_date('%efective_date$s', 'YYYY-MM-DD HH24:MI:SS')   
          and (SDO_RELATE("VCSGISREPO_DATA1"."DAT_GEOM",%roi$s,'mask=ANYINTERACT') = 'TRUE')
	group by "VCSGISREPO_DATA1"."DAT_FEATURERELATEDCODE", "VCSGISREPO_DATA1"."DAT_EFECTIVEDATE", "VCSGISREPO_DATA1"."DAT_REVNUMBER", "VCSGISREPO_DATA1"."DAT_OPERATION"
	having not (
	  ("VCSGISREPO_DATA1"."DAT_OPERATION" = %DELETE$s )
	  or  ("VCSGISREPO_DATA1"."DAT_OPERATION" = %UPDATE$s and MIN("VCSGISREPO_DATA2"."DAT_OPERATION") = %DELETE$s )
	  or  ("VCSGISREPO_DATA1"."DAT_OPERATION" = %INSERT$s and (MIN("VCSGISREPO_DATA2"."DAT_OPERATION") = %DELETE$s  or max("VCSGISREPO_DATA2"."DAT_OPERATION") = %UPDATE$s or min("VCSGISREPO_DATA2"."DAT_OPERATION") = %UPDATE$s ))
	  or  ("VCSGISREPO_DATA1"."DAT_OPERATION" = %UPDATE$s and (max("VCSGISREPO_DATA2"."DAT_OPERATION") = %UPDATE$s or min("VCSGISREPO_DATA2"."DAT_OPERATION") = %UPDATE$s) and "VCSGISREPO_DATA1"."DAT_EFECTIVEDATE" <= max("VCSGISREPO_DATA2"."DAT_EFECTIVEDATE") and "VCSGISREPO_DATA1"."DAT_REVNUMBER" <> max("VCSGISREPO_DATA2"."DAT_REVNUMBER"))
	  or  ("VCSGISREPO_DATA1"."DAT_OPERATION" = %INSERT$s and max("VCSGISREPO_DATA2"."DAT_OPERATION") = %INSERT$s and "VCSGISREPO_DATA1"."DAT_EFECTIVEDATE" <= max("VCSGISREPO_DATA2"."DAT_EFECTIVEDATE") and "VCSGISREPO_DATA1"."DAT_REVNUMBER" <> max("VCSGISREPO_DATA2"."DAT_REVNUMBER"))  )
)
@end getDataOfEntityFromEfectiveDateAndRoi

@begin dateFormat
yyyy-MM-dd HH:mm:ss
@end dateFormat

@begin createWorkspaceIndex1
create index idx_wschanges_1 on VCSGIS_WSCHANGES (COD_ENTITY ASC, WSCH_OPERATION DESC, COD_WSCHANGE ASC)
@end createWorkspaceIndex1

@begin createWorkspaceIndex2
create index idx_wschanges_2 on VCSGIS_WSCHANGES (WSCH_SELECTED ASC, WSCH_OPERATION ASC)
@end createWorkspaceIndex2

@begin createWorkspaceIndex3
create index idx_remotechanges_3 on VCSGIS_REMOTECHANGES (COD_ENTITY ASC, RCH_SELECTED ASC)
@end createWorkspaceIndex3

@begin updateStateFromLocalChanges
@param status
update VCSGIS_REMOTECHANGES 
set RCH_STATUS = %status$d 
where exists (select 1 from VCSGIS_WSCHANGES where RCH_DATACODE = WSCH_FEATURECODE FETCH FIRST 1 ROWS ONLY)
@end updateStateFromLocalChanges

@begin removeLocalChangesRelatedToSelectedRemoteChanges
@param entity_code
delete from VCSGIS_WSCHANGES 
where COD_ENTITY = '%entity_code$s' and WSCH_FEATURECODE in (
    select RCH_DATACODE from VCSGIS_REMOTECHANGES where RCH_DATACODE = WSCH_FEATURECODE and UPPER(RCH_SELECTED) = 'T')
@end removeLocalChangesRelatedToSelectedRemoteChanges

@begin getChangesWidthUserData
@param entity_name
@param FeatureIdFieldName
@param RelatedFeatureCode
@param filter
SELECT * FROM VCSGIS_WSCHANGES left join "%entity_name$s" on WSCH_FEATURECODE = "%FeatureIdFieldName$s" WHERE "%FeatureIdFieldName$s" <> '%RelatedFeatureCode$s' AND (%filter$s)
@end getChangesWidthUserData

@begin alterTableAddColumnVCSGISCODE
@param entity_name
ALTER TABLE "%entity_name$s" ADD COLUMN "VCSGISCODE" VARCHAR(40)
@end alterTableAddColumnVCSGISCODE

@begin alterTableDropPrimaryKey
@param entity_name
ALTER TABLE "%entity_name$s" DROP PRIMARY KEY
@end alterTableDropPrimaryKey

@begin alterTableAlterColumnVCSGISCODESetNotNull
@param entity_name
ALTER TABLE "%entity_name$s" ALTER COLUMN "VCSGISCODE" SET NOT NULL
@end alterTableAlterColumnVCSGISCODESetNotNull

@begin alterTableAddPrimaryKeyVCSGISCODE
@param entity_name
ALTER TABLE "%entity_name$s" ADD PRIMARY KEY ("VCSGISCODE")
@end alterTableAddPrimaryKeyVCSGISCODE

@begin createFunctionsPre1
create or replace PACKAGE VCSGISPKG AS
    TYPE VCSGISREPO_DATA_ROWTYPE IS RECORD (
          COD_DATA NVARCHAR2(60)
        , COD_REVISION NVARCHAR2(60)
        , COD_ENTITY NVARCHAR2(60)
        , DAT_OPERATION NUMBER(9, 0)
        , DAT_REVNUMBER NUMBER(18, 0)
        , DAT_EFECTIVEDATE TIMESTAMP(6)
        , DAT_FEATURERELATEDCODE NVARCHAR2(60)
        , DAT_GEOM SDO_GEOMETRY
        , DAT_DATA NCLOB
    );
    TYPE VCSGISREPO_DATA_TYPE IS TABLE OF VCSGISREPO_DATA_ROWTYPE;

    FUNCTION CHECKOUT(PCOD_ENTITY IN VARCHAR2, PDAT_REVNUMBER IN LONG, PROI SDO_GEOMETRY DEFAULT NULL) RETURN VCSGISREPO_DATA_TYPE PIPELINED;

    function BlobToHex(pBlob in blob) return clob;
    
    function HexToBlob(pHexClob in clob) return blob;
END VCSGISPKG;
@end createFunctionsPre1

@begin createFunctionsPost1
create or replace PACKAGE BODY VCSGISPKG AS
    TYPE MAP_VARCHAR_NUMBER IS TABLE OF NUMBER  INDEX BY VARCHAR2(64);  

    FUNCTION CHECKOUT(PCOD_ENTITY IN VARCHAR2, PDAT_REVNUMBER IN LONG, PROI SDO_GEOMETRY DEFAULT NULL)
        RETURN VCSGISREPO_DATA_TYPE
        PIPELINED
    IS
        CURSOR CURSOR_DATA_WITHOUT_ROI IS
            SELECT * 
            FROM VCSGISREPO_DATA
            WHERE 
                COD_ENTITY = PCOD_ENTITY 
                AND DAT_REVNUMBER <= PDAT_REVNUMBER
            ORDER BY DAT_REVNUMBER DESC
        ;
        CURSOR CURSOR_DATA_WITH_ROI IS
            SELECT * 
            FROM VCSGISREPO_DATA
            WHERE 
                COD_ENTITY = PCOD_ENTITY 
                AND DAT_REVNUMBER <= PDAT_REVNUMBER
                AND (DAT_GEOM IS NULL OR SDO_RELATE(DAT_GEOM, PROI,'mask=ANYINTERACT') = 'TRUE')
            ORDER BY DAT_REVNUMBER DESC
        ;
        DELETEDS MAP_VARCHAR_NUMBER;
        UPDATEDS_AND_INSERTEDS MAP_VARCHAR_NUMBER;
        VCOD_DATA VCSGISREPO_DATA.COD_DATA%%TYPE;
        VDAT_FEATURERELATEDCODE VCSGISREPO_DATA.DAT_FEATURERELATEDCODE%%TYPE;
        VDAT_OPERATION VCSGISREPO_DATA.DAT_OPERATION%%TYPE;

    BEGIN
        IF PROI IS NULL THEN
            FOR record IN CURSOR_DATA_WITHOUT_ROI
            LOOP
                -- VCOD_DATA := record.COD_DATA;
                VDAT_FEATURERELATEDCODE := record.DAT_FEATURERELATEDCODE;
                VDAT_OPERATION := record.DAT_OPERATION;
    
                IF DELETEDS.EXISTS(VDAT_FEATURERELATEDCODE) THEN
                    CONTINUE;
                END IF;
                IF UPDATEDS_AND_INSERTEDS.EXISTS(VDAT_FEATURERELATEDCODE) THEN
                    CONTINUE;
                END IF;  
                IF VDAT_OPERATION = 0 THEN -- DEL
                        DELETEDS(VDAT_FEATURERELATEDCODE) := 1;
                        CONTINUE;
                ELSIF VDAT_OPERATION = 1 THEN -- UPD
                        UPDATEDS_AND_INSERTEDS(VDAT_FEATURERELATEDCODE) := 1;
                ELSIF VDAT_OPERATION = 2 THEN -- INS
                        UPDATEDS_AND_INSERTEDS(VDAT_FEATURERELATEDCODE) := 1;
                END IF;
    
                PIPE ROW (record);
            END LOOP; 
        ELSE
            FOR record IN CURSOR_DATA_WITH_ROI
            LOOP
                -- VCOD_DATA := record.COD_DATA;
                VDAT_FEATURERELATEDCODE := record.DAT_FEATURERELATEDCODE;
                VDAT_OPERATION := record.DAT_OPERATION;
    
                IF DELETEDS.EXISTS(VDAT_FEATURERELATEDCODE) THEN
                    CONTINUE;
                END IF;
                IF UPDATEDS_AND_INSERTEDS.EXISTS(VDAT_FEATURERELATEDCODE) THEN
                    CONTINUE;
                END IF;  
                IF VDAT_OPERATION = 0 THEN -- DEL
                        DELETEDS(VDAT_FEATURERELATEDCODE) := 1;
                        CONTINUE;
                ELSIF VDAT_OPERATION = 1 THEN -- UPD
                        UPDATEDS_AND_INSERTEDS(VDAT_FEATURERELATEDCODE) := 1;
                ELSIF VDAT_OPERATION = 2 THEN -- INS
                        UPDATEDS_AND_INSERTEDS(VDAT_FEATURERELATEDCODE) := 1;
                END IF;
    
                PIPE ROW (record);
            END LOOP; 
        END IF;
    END;
    
    function BlobToHex(pBlob in blob) return clob is
    -- https://paulzipblog.wordpress.com/2021/11/28/blob-to-hex-and-hex-to-blob/
    -- Converts a blob to a clob containing the hex representation of the blob
      BUFF_SIZE constant integer := 16383; -- Each raw byte converts to 2 hex digits, so buffer is half of 32766
      vBuffer varchar2(32766 byte);  -- Twice buffer size
      vOffset pls_integer := 1;
      vLength pls_integer := DBMS_LOB.GetLength(pBlob);
      vResult clob;
    begin
      if coalesce(vLength, 0) > 0 then
        DBMS_LOB.CreateTemporary(vResult, True, DBMS_LOB.Call);
        for i in 1..ceil(vLength / BUFF_SIZE)
        loop
          vBuffer := RawToHex(DBMS_LOB.Substr(pBlob, BUFF_SIZE, vOffset));
          DBMS_LOB.WriteAppend(vResult, length(vBuffer), vBuffer);
          vOffset := vOffset + BUFF_SIZE;
        end loop;
      end if;
      return vResult;
    end;
    
     
    function HexToBlob(pHexClob in clob) return blob is
    -- https://paulzipblog.wordpress.com/2021/11/28/blob-to-hex-and-hex-to-blob/
    -- Converts a clob containing hex representation of binary data into a blob
      BUFF_SIZE constant integer := 32764; -- Some Oracle versions have a bug which loses trailing bytes when using buffer sizes > 32764,
      vBuffer raw(16382);
      vOffset pls_integer := 1;
      vLength pls_integer := DBMS_LOB.GetLength(pHexClob);
      vResult blob;
    begin
      if coalesce(vLength, 0) > 0 then
        DBMS_LOB.CreateTemporary(vResult, True, DBMS_LOB.Call);
        for i in 1..ceil(vLength / BUFF_SIZE)
        loop
          vBuffer := HexToRaw(DBMS_LOB.Substr(pHexClob, BUFF_SIZE, vOffset));
          DBMS_LOB.WriteAppend(vResult, UTL_RAW.Length(vBuffer), vBuffer);
          vOffset := vOffset + BUFF_SIZE;
        end loop;
      end if;
      return vResult;
    end;  
END;
@end createFunctionsPost1

@begin getDataOfEntityToRevisionNumberUsingDatabaseFunction
@param revision_number
@param entity_code
@param data_table_name
SELECT * FROM TABLE (VCSGISPKG.CHECKOUT('%entity_code$s', %revision_number$s,NULL))
@end getDataOfEntityToRevisionNumberUsingDatabaseFunction

@begin getDataOfEntityToRevisionNumberAndRoiUsingDatabaseFunction
@param revision_number
@param entity_code
@param roi
@param data_table_name
SELECT * FROM TABLE (VCSGISPKG.CHECKOUT('%entity_code$s', %revision_number$s, %roi$s))
@end getDataOfEntityToRevisionNumberAndRoiUsingDatabaseFunction

@begin defaultCheckoutMode
USESELECT (posible values USEDBFUNCTION, USESELECT, USEAPPFILTER)
@end defaultCheckoutMode

@begin getDataOfEntityFromFeatureRelatedCode
@param featureRelatedCode
@param entity_code
@param data_table_name
select *, "VCSGISREPO_REVISIONS"."REV_COMMENT"
from "%data_table_name$s" 
left join "VCSGISREPO_REVISIONS" on "%data_table_name$s"."COD_REVISION" = "VCSGISREPO_REVISIONS"."COD_REVISION"
where 
        "%data_table_name$s"."COD_ENTITY" = '%entity_code$s' AND
        "%data_table_name$s"."DATA_FEATURERELATEDCODE" = '%featureRelatedCode$s';
order by "data_table_name$s"."DATA_EFECTIVEDATE" asc
@end getDataOfEntityFromFeatureRelatedCode