@begin dateFormat
yyyy-MM-dd HH24:mm:ss.S
@end dateFormat

@begin createWorkspaceIndex1
create index if not exists idx_wschanges_1 on ONLINE_WSCHANGES (COD_ENTITY ASC, WSCH_OPERATION DESC, COD_WSCHANGE ASC)
@end createWorkspaceIndex1

@begin createWorkspaceIndex2
create index if not exists idx_wschanges_2 on ONLINE_WSCHANGES (WSCH_SELECTED ASC, WSCH_OPERATION ASC)
@end createWorkspaceIndex2

@begin createWorkspaceIndex3
create index if not exists idx_remotechanges_3 on ONLINE_REMOTECHANGES (COD_ENTITY ASC, RCH_SELECTED ASC)
@end createWorkspaceIndex3

@begin updateStateFromLocalChanges
@param status
update ONLINE_REMOTECHANGES 
set RCH_STATUS = %status$d 
where exists (select 1 from ONLINE_WSCHANGES where RCH_FEATURECODE = WSCH_FEATURECODE LIMIT 1)
@end updateStateFromLocalChanges

@begin removeLocalChangesRelatedToSelectedRemoteChanges
@param entityCode
delete from ONLINE_WSCHANGES 
where COD_ENTITY = '%entityCode$s' and WSCH_FEATURECODE in (
    select RCH_FEATURECODE from ONLINE_REMOTECHANGES where RCH_FEATURECODE = WSCH_FEATURECODE and CAST(RCH_SELECTED as INT)=1)
@end removeLocalChangesRelatedToSelectedRemoteChanges

@begin getChangesWidthUserData
@param EntityName
@param FeatureIdFieldName
@param RelatedFeatureCode
@param filter
SELECT * FROM ONLINE_WSCHANGES left join "%EntityName$s" on WSCH_FEATURECODE = "%FeatureIdFieldName$s" WHERE "%FeatureIdFieldName$s" <> '%RelatedFeatureCode$s' AND (%filter$s)
@end getChangesWidthUserData

@begin alterTableDropPrimaryKey
@param EntityName
ALTER TABLE "%EntityName$s" DROP PRIMARY KEY
@end alterTableDropPrimaryKey

@begin defaultCheckoutMode
USESELECT (posible values USEDBFUNCTION, USESELECT, USEAPPFILTER)
@end defaultCheckoutMode
