/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.transforms.implementations;

import com.sun.org.apache.xml.internal.security.c14n.CanonicalizationException;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.internal.security.transforms.TransformSpi;
import com.sun.org.apache.xml.internal.security.transforms.TransformationException;
import com.sun.org.apache.xml.internal.security.utils.JavaUtils;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import java.io.IOException;
import java.io.OutputStream;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class TransformBase64Decode
extends TransformSpi {
    @Override
    protected String engineGetURI() {
        return "http://www.w3.org/2000/09/xmldsig#base64";
    }

    @Override
    protected XMLSignatureInput enginePerformTransform(XMLSignatureInput xMLSignatureInput, OutputStream outputStream, Element element, String string, boolean bl) throws IOException, CanonicalizationException, TransformationException {
        if (xMLSignatureInput.isElement()) {
            Node node = xMLSignatureInput.getSubNode();
            if (xMLSignatureInput.getSubNode().getNodeType() == 3) {
                node = node.getParentNode();
            }
            StringBuilder stringBuilder = new StringBuilder();
            this.traverseElement((Element)node, stringBuilder);
            if (outputStream == null) {
                byte[] byArray = XMLUtils.decode(stringBuilder.toString());
                XMLSignatureInput xMLSignatureInput2 = new XMLSignatureInput(byArray);
                xMLSignatureInput2.setSecureValidation(bl);
                return xMLSignatureInput2;
            }
            byte[] byArray = XMLUtils.decode(stringBuilder.toString());
            outputStream.write(byArray);
            XMLSignatureInput xMLSignatureInput3 = new XMLSignatureInput((byte[])null);
            xMLSignatureInput3.setSecureValidation(bl);
            xMLSignatureInput3.setOutputStream(outputStream);
            return xMLSignatureInput3;
        }
        if (xMLSignatureInput.isOctetStream() || xMLSignatureInput.isNodeSet()) {
            Object object;
            if (outputStream == null) {
                byte[] byArray = xMLSignatureInput.getBytes();
                byte[] byArray2 = XMLUtils.decode(byArray);
                XMLSignatureInput xMLSignatureInput4 = new XMLSignatureInput(byArray2);
                xMLSignatureInput4.setSecureValidation(bl);
                return xMLSignatureInput4;
            }
            if (xMLSignatureInput.isByteArray() || xMLSignatureInput.isNodeSet()) {
                object = XMLUtils.decode(xMLSignatureInput.getBytes());
                outputStream.write((byte[])object);
            } else {
                object = JavaUtils.getBytesFromStream(xMLSignatureInput.getOctetStreamReal());
                byte[] byArray = XMLUtils.decode((byte[])object);
                outputStream.write(byArray);
            }
            object = new XMLSignatureInput((byte[])null);
            ((XMLSignatureInput)object).setSecureValidation(bl);
            ((XMLSignatureInput)object).setOutputStream(outputStream);
            return object;
        }
        throw new TransformationException("empty", new Object[]{"Unrecognized XMLSignatureInput state"});
    }

    private void traverseElement(Element element, StringBuilder stringBuilder) {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (1 == node.getNodeType()) {
                this.traverseElement((Element)node, stringBuilder);
                continue;
            }
            if (3 != node.getNodeType()) continue;
            stringBuilder.append(((Text)node).getData());
        }
    }
}

