/*
 * Decompiled with CFR 0.152.
 */
package sun.reflect.generics.reflectiveObjects;

import java.lang.annotation.Annotation;
import java.lang.annotation.AnnotationFormatError;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import sun.reflect.annotation.AnnotationSupport;
import sun.reflect.annotation.AnnotationType;
import sun.reflect.annotation.TypeAnnotationParser;
import sun.reflect.generics.factory.GenericsFactory;
import sun.reflect.generics.reflectiveObjects.LazyReflectiveObjectGenerator;
import sun.reflect.generics.tree.FieldTypeSignature;
import sun.reflect.generics.visitor.Reifier;
import sun.reflect.misc.ReflectUtil;

public class TypeVariableImpl<D extends GenericDeclaration>
extends LazyReflectiveObjectGenerator
implements TypeVariable<D> {
    D genericDeclaration;
    private String name;
    private Type[] bounds;
    private FieldTypeSignature[] boundASTs;
    private static final Annotation[] EMPTY_ANNOTATION_ARRAY = new Annotation[0];

    private TypeVariableImpl(D d, String string, FieldTypeSignature[] fieldTypeSignatureArray, GenericsFactory genericsFactory) {
        super(genericsFactory);
        this.genericDeclaration = d;
        this.name = string;
        this.boundASTs = fieldTypeSignatureArray;
    }

    private FieldTypeSignature[] getBoundASTs() {
        assert (this.bounds == null);
        return this.boundASTs;
    }

    public static <T extends GenericDeclaration> TypeVariableImpl<T> make(T t, String string, FieldTypeSignature[] fieldTypeSignatureArray, GenericsFactory genericsFactory) {
        if (!(t instanceof Class || t instanceof Method || t instanceof Constructor)) {
            throw new AssertionError((Object)("Unexpected kind of GenericDeclaration" + t.getClass().toString()));
        }
        return new TypeVariableImpl<T>(t, string, fieldTypeSignatureArray, genericsFactory);
    }

    @Override
    public Type[] getBounds() {
        if (this.bounds == null) {
            FieldTypeSignature[] fieldTypeSignatureArray = this.getBoundASTs();
            Type[] typeArray = new Type[fieldTypeSignatureArray.length];
            for (int i = 0; i < fieldTypeSignatureArray.length; ++i) {
                Reifier reifier = this.getReifier();
                fieldTypeSignatureArray[i].accept(reifier);
                typeArray[i] = reifier.getResult();
            }
            this.bounds = typeArray;
        }
        return (Type[])this.bounds.clone();
    }

    @Override
    public D getGenericDeclaration() {
        if (this.genericDeclaration instanceof Class) {
            ReflectUtil.checkPackageAccess((Class)this.genericDeclaration);
        } else if (this.genericDeclaration instanceof Method || this.genericDeclaration instanceof Constructor) {
            ReflectUtil.conservativeCheckMemberAccess((Member)this.genericDeclaration);
        } else {
            throw new AssertionError((Object)"Unexpected kind of GenericDeclaration");
        }
        return this.genericDeclaration;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object object) {
        if (object instanceof TypeVariable && object.getClass() == TypeVariableImpl.class) {
            TypeVariable typeVariable = (TypeVariable)object;
            Object d = typeVariable.getGenericDeclaration();
            String string = typeVariable.getName();
            return Objects.equals(this.genericDeclaration, d) && Objects.equals(this.name, string);
        }
        return false;
    }

    public int hashCode() {
        return this.genericDeclaration.hashCode() ^ this.name.hashCode();
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> clazz) {
        Objects.requireNonNull(clazz);
        return (T)TypeVariableImpl.mapAnnotations(this.getAnnotations()).get(clazz);
    }

    @Override
    public <T extends Annotation> T getDeclaredAnnotation(Class<T> clazz) {
        Objects.requireNonNull(clazz);
        return this.getAnnotation(clazz);
    }

    @Override
    public <T extends Annotation> T[] getAnnotationsByType(Class<T> clazz) {
        Objects.requireNonNull(clazz);
        return AnnotationSupport.getDirectlyAndIndirectlyPresent(TypeVariableImpl.mapAnnotations(this.getAnnotations()), clazz);
    }

    @Override
    public <T extends Annotation> T[] getDeclaredAnnotationsByType(Class<T> clazz) {
        Objects.requireNonNull(clazz);
        return this.getAnnotationsByType(clazz);
    }

    @Override
    public Annotation[] getAnnotations() {
        int n = this.typeVarIndex();
        if (n < 0) {
            throw new AssertionError((Object)"Index must be non-negative.");
        }
        return TypeAnnotationParser.parseTypeVariableAnnotations(this.getGenericDeclaration(), n);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.getAnnotations();
    }

    @Override
    public AnnotatedType[] getAnnotatedBounds() {
        return TypeAnnotationParser.parseAnnotatedBounds(this.getBounds(), this.getGenericDeclaration(), this.typeVarIndex());
    }

    private int typeVarIndex() {
        TypeVariable<?>[] typeVariableArray = this.getGenericDeclaration().getTypeParameters();
        int n = -1;
        for (TypeVariable<?> typeVariable : typeVariableArray) {
            ++n;
            if (!this.equals(typeVariable)) continue;
            return n;
        }
        return -1;
    }

    private static Map<Class<? extends Annotation>, Annotation> mapAnnotations(Annotation[] annotationArray) {
        LinkedHashMap<Class<? extends Annotation>, Annotation> linkedHashMap = new LinkedHashMap<Class<? extends Annotation>, Annotation>();
        for (Annotation annotation : annotationArray) {
            Class<? extends Annotation> clazz = annotation.annotationType();
            AnnotationType annotationType = AnnotationType.getInstance(clazz);
            if (annotationType.retention() != RetentionPolicy.RUNTIME || linkedHashMap.put(clazz, annotation) == null) continue;
            throw new AnnotationFormatError("Duplicate annotation for class: " + clazz + ": " + annotation);
        }
        return linkedHashMap;
    }
}

