/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.xdg;

import com.sun.deploy.Environment;
import com.sun.deploy.association.Association;
import com.sun.deploy.xdg.BaseDir;
import com.sun.deploy.xdg.MimeGlob2File;
import java.io.File;
import java.util.Iterator;

public class Associations {
    private static Associations instance;

    static synchronized Associations getInstance() {
        if (instance == null) {
            instance = new Associations();
        }
        return instance;
    }

    private Associations() {
    }

    public static String[] getMimeBasePaths(int n) {
        BaseDir baseDir = BaseDir.getInstance();
        if (n == 1) {
            String string = baseDir.getUserDataDir();
            String string2 = string + File.separatorChar + "mime";
            return new String[]{string2};
        }
        String[] stringArray = baseDir.getSystemDataDirs();
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = stringArray[i] + File.separatorChar + "mime";
        }
        return stringArray2;
    }

    public static String[] getMimeBasePaths() {
        int n = Environment.isSystemCacheMode() ? 2 : 1;
        return Associations.getMimeBasePaths(n);
    }

    public static String[] getAppBasePaths(int n) {
        BaseDir baseDir = BaseDir.getInstance();
        if (n == 1) {
            String string = baseDir.getUserDataDir();
            String string2 = string + File.separatorChar + "applications";
            return new String[]{string2};
        }
        String[] stringArray = baseDir.getSystemDataDirs();
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = stringArray[i] + File.separatorChar + "applications";
        }
        return stringArray2;
    }

    public static String[] getAppBasePaths() {
        int n = Environment.isSystemCacheMode() ? 2 : 1;
        return Associations.getAppBasePaths(n);
    }

    private boolean isAssociationExists(String string, Association association) {
        String string2 = string + File.separatorChar + "globs2";
        MimeGlob2File mimeGlob2File = new MimeGlob2File(string2);
        boolean bl = true;
        Iterator iterator = association.getFileExtList().iterator();
        while (iterator.hasNext() && bl) {
            String string3 = (String)iterator.next();
            if (mimeGlob2File.mapsFileExtToMimetype("*" + string3, association.getMimeType())) continue;
            bl = false;
        }
        return bl;
    }

    boolean isAssociationExist(Association association, int n) {
        String[] stringArray = Associations.getMimeBasePaths(n);
        boolean bl = false;
        for (int i = 0; !bl && i < stringArray.length; ++i) {
            if (!this.isAssociationExists(stringArray[i], association)) continue;
            bl = true;
        }
        return bl;
    }

    public static File getMimeTypeFile(Association association, int n) {
        BaseDir baseDir = BaseDir.getInstance();
        String string = null;
        string = n == 2 ? baseDir.getSystemDataDir() : baseDir.getUserDataDir();
        String string2 = string + File.separatorChar + "mime" + File.separatorChar + "packages";
        new File(string2).mkdirs();
        String string3 = association.getMimeType();
        string3 = string3.replace('/', '_');
        String string4 = "oracle-" + association.getName() + "_" + string3 + ".xml";
        return new File(string2 + File.separatorChar + string4);
    }

    public static File getDesktopEntryFile(Association association, int n) {
        BaseDir baseDir = BaseDir.getInstance();
        String string = null;
        string = n == 2 ? baseDir.getSystemDataDir() : baseDir.getUserDataDir();
        String string2 = string + File.separatorChar + "applications";
        new File(string2).mkdirs();
        String string3 = association.getMimeType();
        string3 = string3.replace('/', '_');
        String string4 = "oracle-" + association.getName() + "_" + string3 + ".desktop";
        return new File(string2 + File.separatorChar + string4);
    }
}

